#!/bin/bash

abort()
{
    echo >&2 '
***************
*** ABORTED ***
***************
'
    echo "An error occurred. Exiting..." >&2
    exit 1
}

trap 'abort' 0

set -e
#set -o pipefail
if test -z $1
then
  list=`/bin/ls -f [0-9][0-9]*.tex panel*.tex`
else
  list=$1
fi
echo ${list} # for debugging
# exit # also for debugging
echo `date` > make-panels.log
for i in $list; do
    if test -r $i; then
    echo "Processing $i"
    else
    echo "file $i not found. aborting"; exit 1
    fi
    f=`basename ${i} .tex`
    if test -f $i; then # pdflatex will get stuck if the file isn't there
        echo "processing file $i" >> make-panels.log
        xelatex  -output-driver='xdvipdfmx -z3 -V5' -halt-on-error --interaction=batchmode -enable-write18 -synctex=1 ${f}  >> make-panels.log
    # downsample embedded bitmaps in case there are some:
       gs \
         -sDEVICE=pdfwrite \
         -dCompatibilityLevel=1.5 \
         -dPDFSETTINGS=/printer \
         -dNOPAUSE \
         -dQUIET \
         -dBATCH \
         -dEmbedAllFonts=true \
         -dSubsetFonts=true \
         -dAutoRotatePages=/None \
         -dColorImageResolution=800 \
         -dGrayImageResolution=800 \
         -dMonoImageResolution=800 \
         -dColorImageFilter=/FlateEncode \
         -sOutputFile=downsampled.pdf \
         ${f}.pdf
         mv downsampled.pdf ${f}.pdf

     fi # check if file exists


#    [ $i -eq 0 ] || exit($i) # exit for none-zero return code
#    pdfcrop ${f}.pdf
#    mv ${f}-crop.pdf ${f}.pdf
#    pdftops -eps ${f}.pdf # we don't use this anymore
# one more cycle of conversions, to make the files smalleri
# (but this may cause pixelation, so it's commented)
#    epstopdf ${f}.eps
#    pdftops -eps ${f}.pdf
done

trap : 0

echo >&2 '
************
*** DONE *** 
************
'

