#!/bin/bash
#
shopt -s nullglob
RED='\033[0;31m'
NOCOLOR='\033[0m'

abort()
{
    echo -e >&2 "${RED}
***************
*** ABORTED ***
***************
${NOCOLOR}"
    echo -e "${RED}An error occurred. Exiting...${NOCOLOR}" >&2
    echo "suspected latex error? Check gnuplot-figure.log first."
    echo "also try running \"gnuplot gnuplot-script.plt\" to check for syntax errors"
    echo "in the plt file and make sure you have the epstopdf program available." 
    exit 1
}

trap 'abort' 0
set -e

echo -e "Running Gnuplot and assembling gnuplot-figure.tex + embedded figure"
gnuplot gnuplot-script.plt
cat figure-template.tex > gnuplot-figure.tex
cat embedded-figure.tex >> gnuplot-figure.tex
echo "\end{document}" >> gnuplot-figure.tex;
epstopdf embedded-figure.eps

echo -e "Compiling with XeLaTeX"
xelatex -halt-on-error --interaction=batchmode gnuplot-figure.tex 1>/dev/null

rm embedded-figure.eps embedded-figure.pdf embedded-figure.tex gnuplot-figure.aux gnuplot-figure.tex

echo ""
echo "if everything went well your figure should now be in gnuplot-figure.pdf" 
echo "if you suspect errors, check gnuplot-figure.log first"

trap : 0

