set term epslatex color colortext "Stix" 10 linewidth 1.0 size 8cm,5cm
set out 'embedded-figure.tex'

# colors:
# #AA2222 = Brick Red RGB 170, 34, 34
# #D49090 = same as above but 50% lighter
# #005BBB = UB Blue (new version RGB 0,91,187)
# #80ADDD = same as above but 50% lighter
# #338855 = Sea Green RGB 51, 136, 85
# #99C4AA = same as above but 50% lighter
set style line  3 lt 1 lw 3 linecolor rgb "#AA2222"  # red    solid
set style line  4 lt 0 lw 3 linecolor rgb "#AA2222"  # red    dotted
set style line  5 lt 1 lw 3 linecolor rgb "#D49090"  # red    light
set style line  6 lt 1 lw 3 linecolor rgb "#005BBB"  # blue   solid
set style line  7 lt 0 lw 3 linecolor rgb "#005BBB"  # blue   dotted
set style line  8 lt 1 lw 3 linecolor rgb "#80ADDD"  # blue   light
set style line  9 lt 1 lw 3 linecolor rgb "#338855"  # green  solid
set style line 10 lt 0 lw 3 linecolor rgb "#338855"  # green  dotted
set style line 11 lt 1 lw 3 linecolor rgb "#99C4AA"  # green  light

set pointsize 1.0
set xzeroaxis # have an axis at y=0
unset key # if set, there will be no plot key

# plot ranges
set xrange [1.5:6.0]  # use * to let gnuplot determine limit from data, e.g. [*,*] is default autoscale
#set x2range [25:5]
#set yrange [*,*]
#set y2range [*,*]

# axis labels (offsets require trial & error):
# for Latex code, use \\ instead of \
#set x2label "$\\lambda$ (nm)"  offset 0, -1
set ylabel "$\\epsilon$  (L mol$^{-1}$ cm$^{-1}$)"  offset 1, 0
set y2label "Osc. Strength"  offset -1.7, 0
set xlabel "$E$ (eV)"  offset 0, 1

# ticks
set xtics 1 nomirror  offset 0, 0.5
set x2tics ("250" 4.96, "350" 3.54, "450" 2.75) nomirror  offset 0,-0.5  # wavelength scale on top
set ytics 5 nomirror  offset 0.5,0
set y2tics 0.1

# margins to have space for axis labels, requires trial & error
set lmargin 5
set rmargin 5
set bmargin 2
set tmargin 2

# set other plot labels
yexp=4  # exponent for y-data scaling
set label sprintf("{\\footnotesize $\\times 10^{%d}$}" ,yexp) at graph 0.05, graph 1.05

set label "$\\lambda$ (nm)" at graph 0.53,1.12

# now do the plot
cy=10**-yexp
plot  "stick-spectrum.dat" u 1:2 axes x1y2 w imp ls 8, \
      "broadened-spectrum.dat" u 1:(cy*$2) axes x1y1 w l ls 3

set out

